// ================= SLIDER =================
const slider = document.querySelector('#slider');
if (slider) {
  const slides = Array.from(slider.querySelectorAll('.slide'));
  let current = 0;
  if (slides.length) slides[current].classList.add('active');

  const prevBtn = slider.querySelector('.prev');
  const nextBtn = slider.querySelector('.next');

  function go(toIndex, direction) {
    const oldSlide = slides[current];
    const newIndex = (toIndex + slides.length) % slides.length;
    const newSlide = slides[newIndex];

    // Place new slide to correct side before animating
    newSlide.style.transition = "none";
    newSlide.style.transform = (direction === 'next') ? "translateX(100%)" : "translateX(-100%)";
    newSlide.offsetHeight; // force reflow

    // Animate both
    newSlide.style.transition = "transform 0.6s ease";
    oldSlide.style.transition = "transform 0.6s ease";
    oldSlide.style.transform = (direction === 'next') ? "translateX(-100%)" : "translateX(100%)";
    newSlide.style.transform = "translateX(0)";

    // Cleanup
    newSlide.classList.add('active');
    oldSlide.classList.remove('active');
    current = newIndex;
  }

  if (prevBtn && nextBtn) {
    nextBtn.addEventListener('click', () => go(current + 1, 'next'));
    prevBtn.addEventListener('click', () => go(current - 1, 'prev'));
  }
}

// ================= SCROLL TO TOP =================
const gotoBtn = document.querySelector(".gotoBtn");
if (gotoBtn) {
  window.addEventListener("scroll", () => {
    if (window.scrollY > 300) {
      gotoBtn.classList.add("show");
    } else {
      gotoBtn.classList.remove("show");
    }
  });

  gotoBtn.addEventListener("click", () => {
    window.scrollTo({ top: 0, behavior: "smooth" });
  });
}

// ================= DARK MODE =================
const toggleBtn = document.querySelector('.theme-toggle');
if (toggleBtn) {
  const body = document.body;
  const storedMode = localStorage.getItem('mode');
  if (storedMode === 'dark') body.classList.add('dark');

  toggleBtn.addEventListener('click', () => {
    body.classList.toggle('dark');
    localStorage.setItem('mode', body.classList.contains('dark') ? 'dark' : 'light');
  });
}

// ================= SEARCH TOGGLE =================
const iconWrapper = document.querySelector('.iconWrapper');
const searchBox = document.querySelector('.searchBox');
if (iconWrapper && searchBox) {
  let isOpen = false;
  iconWrapper.addEventListener('click', () => {
    isOpen = !isOpen;
    if (isOpen) {
      iconWrapper.innerHTML = "×";
      searchBox.style.display = "flex";
    } else {
      iconWrapper.innerHTML = '<img src="images/search.png" alt="search" style="width:18px;height:18px;">';
      searchBox.style.display = "none";
    }
  });
}

// ================= HAMBURGER MENU =================
const hamburger = document.querySelector('.hamburger');
const sidemenu = document.querySelector('.sidemenu');
const overlay = document.querySelector('.sidemenuOverlay');
if (hamburger && sidemenu && overlay) {
  const HAMBURGER_SRC = 'images/hamburger.png';
  const CLOSE_SRC = 'images/close.png';
  let open = false;

  hamburger.addEventListener('click', () => {
    open = !open;
    sidemenu.classList.toggle('active', open);
    overlay.classList.toggle('active', open);
    hamburger.src = open ? CLOSE_SRC : HAMBURGER_SRC;
  });

  overlay.addEventListener('click', () => {
    open = false;
    sidemenu.classList.remove('active');
    overlay.classList.remove('active');
    hamburger.src = HAMBURGER_SRC;
  });
}

// ================= HEADER BORDER =================
const header = document.querySelector('.headerthree');
if (header) {
  window.addEventListener('scroll', () => {
    if (window.scrollY > 0) {
      header.classList.add('stuck');
    } else {
      header.classList.remove('stuck');
    }
  });
}
